<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Edit Profile
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

		<?php
        echo $this->Form->create('User', array(
            'inputDefaults' => array(
                'label' => false,
                'div' => false,
                'class' => 'form-control placeholder-no-fix',
                'error' => array(
                    'attributes' => array('wrap' => 'span', 'class' => 'help-block')
                )
            )
        ));

        echo $this->Form->input('id', array('value' => $this->Session->read('Auth.User.id'), 'type' => 'hidden'));
        ?>


        <div class="form-group">
            <label for="UserUsername" class="control-label">Username</label>
            <p class="form-control-static">
                <input type="text" id="UserUsername" class="form-control" placeholder="<?php echo $this->Session->read('Auth.User.username'); ?>" disabled>
            </p>
        </div>

        <div class="row">
            <div class="col-sm-6">

                <div class="form-group <?php echo($this->Form->isFieldError('first_name') ? 'has-error' : ''); ?>">
                    <label class="control-label" for="UserFirstName">First Name</label>
                    <?php echo $this->Form->input('first_name'); ?>
                </div>

            </div>
            <div class="col-sm-6">

                <div class="form-group <?php echo($this->Form->isFieldError('last_name') ? 'has-error' : ''); ?>">
                    <label class="control-label" for="UserLastName">Last Name</label>
                    <?php echo $this->Form->input('last_name'); ?>
                </div>

            </div>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('email') ? 'has-error' : ''); ?>">
            <label class="control-label" for="UserEmail">Email</label>
            <?php echo $this->Form->input('email', array('disabled' => 'disabled')); ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('country') ? 'has-error' : ''); ?>">
            <label class="control-label" for="UserCountry">Country</label>
            <?php
            echo $this->Form->input('country', array('options' => get_countries(), 'empty' => ' '));
            ?>
        </div>

        <?php echo $this->Form->end(array('label' => 'Submit', 'class' => 'btn btn-primary btn-lg pull-right')); ?>


    </div>
</div>
<!-- END PAGE CONTENT-->